# Evaluate semantic segmenttion IOU accuracy

import os
import numpy as np
import cv2
##########################Input folders: Semantic maps  ground truth and predicted in the simple dataset format##############################################################################################3
GTSemanticDir="/scratch/gobi2/seppel/Chemscape/ChemPicsV1.0/Simple/Test/Semantic/" # Semantic folder of the simple data set


PredSemanticDir="//scratch/gobi2/seppel/Chemscape/Test/Out/NewModular_With_ClassFromFrom_Instance_NO_Eval_SET2/Semantic" # Semantic folder of the predicted semantic  map in the format of the simple dataset
#NewModular_With_ClassFromFrom_Instance_NO_Eval_SET2_Semantic_WithEval
##################################################################################################################################################################################################################3
IgnoreDir=GTSemanticDir+"/5_Ignore/" # ingore region for each image


IOUperPixelPerClass=[]
IOUperImagePerClass=[]
print("Evaluating")

#---------------------Calculate IOU per class----------------------------------------------------------------------------------------------
print("Class\t Per pixel IOU\tPer Pixel Precision\tPer Pixel Recall\tPer image IOU\t")
for Class in os.listdir(GTSemanticDir):
    if Class=='5_Ignore' or Class=='15_Other Material': continue
    interList = [] # intersection per image
    unionList = [] # Union per image

    iouList=[]
    PredSumList = []
    GTSumList = []
    GTDir=GTSemanticDir+"/"+Class+"/"
    PredDir = PredSemanticDir + "/" + Class + "/"
    if not os.path.isdir(PredDir):
        PredDir = PredSemanticDir + "/" +Class[Class.find("_") + 1:]+ "/"
    if not os.path.isdir(PredDir): print("error class missing in prediction folder "+Class)
#------------------------Calculate IOU per file----------------------------------------------------------------------------------------
    for Fname in os.listdir(IgnoreDir):
       #...........Reade files...........................................................
         Ignore=cv2.imread(IgnoreDir+Fname,0)
         if os.path.exists(PredDir+Fname):
             Pred = cv2.imread(PredDir + Fname,0)
         else:
             Pred = np.zeros(Ignore.shape)

         if os.path.exists(GTDir + Fname):
            GT = cv2.imread(GTDir + Fname, 0)
         else:
            GT= np.zeros(Ignore.shape)

#.................update ignored regions..........................................................
        # Ignore[GT==2]=1 # ignore ocluded areas in evaluation
         GT[GT>1]=0
         Pred[Pred>1]=0

         GT[Ignore>0] = 0
         Pred[Ignore>0] = 0

#.......................calculate IOU per file..............................................................


         intersection=(GT*Pred).sum()
         union=GT.sum()+Pred.sum()-intersection
         if union>0:
           interList.append(intersection)   # intersection per image
           unionList.append(union) # Union per image
           iouList.append(intersection/union)
           PredSumList.append(Pred.sum())
           GTSumList.append(GT.sum())
#,,,,,,,,,,,,,,,,,,,,,Calculate mean iou for a class............................................................
    if len(unionList)>0:
            print(Class+"\t"+str(np.sum(interList)/(np.sum(unionList)+0.0001)) +"\t"+str(np.sum(interList)/(np.sum(PredSumList)+0.0001))+"\t"+str(np.sum(interList)/(np.sum(GTSumList)+0.0001)) + "\t"+str(np.mean(iouList)))


