/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeConsumer;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureAlgorithmsExtension;
import sun.security.ssl.SignatureScheme;

final class CertSignAlgsExtension {
    static final HandshakeProducer chNetworkProducer = new CHCertSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHCertSignatureSchemesConsumer();
    static final HandshakeConsumer chOnTradeConsumer = new CHCertSignatureSchemesUpdate();
    static final HandshakeProducer crNetworkProducer = new CRCertSignatureSchemesProducer();
    static final SSLExtension.ExtensionConsumer crOnLoadConsumer = new CRCertSignatureSchemesConsumer();
    static final HandshakeConsumer crOnTradeConsumer = new CRCertSignatureSchemesUpdate();
    static final SSLStringizer ssStringizer = new CertSignatureSchemesStringizer();

    CertSignAlgsExtension() {
    }

    private static final class CRCertSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CRCertSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            List<SignatureScheme> list;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            SignatureAlgorithmsExtension.SignatureSchemesSpec signatureSchemesSpec = (SignatureAlgorithmsExtension.SignatureSchemesSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT);
            if (signatureSchemesSpec == null) {
                return;
            }
            clientHandshakeContext.peerRequestedCertSignSchemes = list = SignatureScheme.getSupportedAlgorithms(clientHandshakeContext.sslConfig, clientHandshakeContext.algorithmConstraints, clientHandshakeContext.negotiatedProtocol, signatureSchemesSpec.signatureSchemes);
            clientHandshakeContext.handshakeSession.setPeerSupportedSignatureAlgorithms(list);
        }
    }

    private static final class CRCertSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CRCertSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SignatureAlgorithmsExtension.SignatureSchemesSpec signatureSchemesSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return;
            }
            try {
                signatureSchemesSpec = new SignatureAlgorithmsExtension.SignatureSchemesSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT, signatureSchemesSpec);
        }
    }

    private static final class CRCertSignatureSchemesProducer
    implements HandshakeProducer {
        private CRCertSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return null;
            }
            List<SignatureScheme> list = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, Collections.singletonList(serverHandshakeContext.negotiatedProtocol));
            int n = SignatureScheme.sizeInRecord() * list.size();
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (SignatureScheme signatureScheme : list) {
                Record.putInt16(byteBuffer, signatureScheme.id);
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CR_SIGNATURE_ALGORITHMS_CERT, new SignatureAlgorithmsExtension.SignatureSchemesSpec(serverHandshakeContext.localSupportedSignAlgs));
            return byArray;
        }
    }

    private static final class CHCertSignatureSchemesUpdate
    implements HandshakeConsumer {
        private CHCertSignatureSchemesUpdate() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            List<SignatureScheme> list;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SignatureAlgorithmsExtension.SignatureSchemesSpec signatureSchemesSpec = (SignatureAlgorithmsExtension.SignatureSchemesSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT);
            if (signatureSchemesSpec == null) {
                return;
            }
            serverHandshakeContext.peerRequestedCertSignSchemes = list = SignatureScheme.getSupportedAlgorithms(serverHandshakeContext.sslConfig, serverHandshakeContext.algorithmConstraints, serverHandshakeContext.negotiatedProtocol, signatureSchemesSpec.signatureSchemes);
            serverHandshakeContext.handshakeSession.setPeerSupportedSignatureAlgorithms(list);
            if (!serverHandshakeContext.isResumption && serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
                if (serverHandshakeContext.sslConfig.clientAuthType != ClientAuthType.CLIENT_AUTH_NONE) {
                    serverHandshakeContext.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_REQUEST.id, SSLHandshake.CERTIFICATE_REQUEST);
                }
                serverHandshakeContext.handshakeProducers.put(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE);
                serverHandshakeContext.handshakeProducers.putIfAbsent(SSLHandshake.CERTIFICATE_VERIFY.id, SSLHandshake.CERTIFICATE_VERIFY);
            }
        }
    }

    private static final class CHCertSignatureSchemesConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHCertSignatureSchemesConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            SignatureAlgorithmsExtension.SignatureSchemesSpec signatureSchemesSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return;
            }
            try {
                signatureSchemesSpec = new SignatureAlgorithmsExtension.SignatureSchemesSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT, signatureSchemesSpec);
        }
    }

    private static final class CHCertSignatureSchemesProducer
    implements HandshakeProducer {
        private CHCertSignatureSchemesProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable signature_algorithms_cert extension", new Object[0]);
                }
                return null;
            }
            if (clientHandshakeContext.localSupportedSignAlgs == null) {
                clientHandshakeContext.localSupportedSignAlgs = SignatureScheme.getSupportedAlgorithms(clientHandshakeContext.sslConfig, clientHandshakeContext.algorithmConstraints, clientHandshakeContext.activeProtocols);
            }
            int n = SignatureScheme.sizeInRecord() * clientHandshakeContext.localSupportedSignAlgs.size();
            byte[] byArray = new byte[n + 2];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Record.putInt16(byteBuffer, n);
            for (SignatureScheme signatureScheme : clientHandshakeContext.localSupportedSignAlgs) {
                Record.putInt16(byteBuffer, signatureScheme.id);
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SIGNATURE_ALGORITHMS_CERT, new SignatureAlgorithmsExtension.SignatureSchemesSpec(clientHandshakeContext.localSupportedSignAlgs));
            return byArray;
        }
    }

    private static final class CertSignatureSchemesStringizer
    implements SSLStringizer {
        private CertSignatureSchemesStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SignatureAlgorithmsExtension.SignatureSchemesSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }
}

