/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import de.jollyday.HolidayManager;
import de.jollyday.config.Configuration;
import de.jollyday.config.Holiday;
import de.jollyday.config.Holidays;
import de.jollyday.impl.XMLManager;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.time.JodaTimeUtils;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Generics;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JollyDayHolidays
implements Env.Binder {
    private static Logger logger = LoggerFactory.getLogger(JollyDayHolidays.class);
    private HolidayManager holidayManager;
    private Map<String, JollyHoliday> holidays;
    private String varPrefix = "JH_";

    @Override
    public void init(String prefix, Properties props) {
        String xmlPath = props.getProperty(prefix + "xml", "edu/stanford/nlp/models/sutime/jollyday/Holidays_sutime.xml");
        String xmlPathType = props.getProperty(prefix + "pathtype", "classpath");
        this.varPrefix = props.getProperty(prefix + "prefix", this.varPrefix);
        logger.info("Initializing JollyDayHoliday for SUTime from {} {} as {}", new Object[]{xmlPathType, xmlPath, prefix});
        Properties managerProps = new Properties();
        managerProps.setProperty("manager.impl", "edu.stanford.nlp.time.JollyDayHolidays$MyXMLManager");
        try {
            URL holidayXmlUrl;
            if (xmlPathType.equalsIgnoreCase("classpath")) {
                holidayXmlUrl = this.getClass().getClassLoader().getResource(xmlPath);
            } else if (xmlPathType.equalsIgnoreCase("file")) {
                holidayXmlUrl = new URL("file:///" + xmlPath);
            } else if (xmlPathType.equalsIgnoreCase("url")) {
                holidayXmlUrl = new URL(xmlPath);
            } else {
                throw new IllegalArgumentException("Unsupported " + prefix + "pathtype = " + xmlPathType);
            }
            this.holidayManager = HolidayManager.getInstance((URL)holidayXmlUrl, (Properties)managerProps);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (!(this.holidayManager instanceof MyXMLManager)) {
            throw new AssertionError((Object)"Did not get back JollyDayHolidays$MyXMLManager");
        }
        Configuration config = ((MyXMLManager)this.holidayManager).getConfiguration();
        this.holidays = this.getAllHolidaysMap(config);
    }

    @Override
    public void bind(Env env) {
        if (this.holidays != null) {
            for (Map.Entry<String, JollyHoliday> holidayEntry : this.holidays.entrySet()) {
                JollyHoliday jh = holidayEntry.getValue();
                env.bind(this.varPrefix + holidayEntry.getKey(), jh);
            }
        }
    }

    public Map<String, JollyHoliday> getAllHolidaysMap(Set<Holiday> allHolidays) {
        Map<String, JollyHoliday> map = Generics.newHashMap();
        for (Holiday h : allHolidays) {
            String descKey = h.getDescriptionPropertiesKey();
            if (descKey == null) continue;
            descKey = descKey.replaceAll(".*\\.", "");
            JollyHoliday jh = new JollyHoliday(descKey, this.holidayManager, h);
            map.put(jh.label, jh);
        }
        return map;
    }

    public Map<String, JollyHoliday> getAllHolidaysMap(Configuration config) {
        Set<Holiday> s = JollyDayHolidays.getAllHolidays(config);
        return this.getAllHolidaysMap(s);
    }

    public CollectionValuedMap<String, JollyHoliday> getAllHolidaysCVMap(Set<Holiday> allHolidays) {
        CollectionValuedMap<String, JollyHoliday> map = new CollectionValuedMap<String, JollyHoliday>();
        for (Holiday h : allHolidays) {
            String descKey = h.getDescriptionPropertiesKey();
            if (descKey == null) continue;
            descKey = descKey.replaceAll(".*\\.", "");
            JollyHoliday jh = new JollyHoliday(descKey, this.holidayManager, h);
            map.add(jh.label, jh);
        }
        return map;
    }

    public CollectionValuedMap<String, JollyHoliday> getAllHolidaysCVMap(Configuration config) {
        Set<Holiday> s = JollyDayHolidays.getAllHolidays(config);
        return this.getAllHolidaysCVMap(s);
    }

    public static void getAllHolidays(Holidays holidays, Set<Holiday> allHolidays) {
        for (Method m : holidays.getClass().getMethods()) {
            if (!JollyDayHolidays.isGetter(m) || m.getReturnType() != List.class) continue;
            try {
                List l = (List)m.invoke((Object)holidays, new Object[0]);
                allHolidays.addAll(l);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create set of holidays.", e);
            }
        }
    }

    public static void getAllHolidays(Configuration config, Set<Holiday> allHolidays) {
        Holidays holidays = config.getHolidays();
        JollyDayHolidays.getAllHolidays(holidays, allHolidays);
        List subConfigs = config.getSubConfigurations();
        for (Configuration c : subConfigs) {
            JollyDayHolidays.getAllHolidays(c, allHolidays);
        }
    }

    public static Set<Holiday> getAllHolidays(Configuration config) {
        Set<Holiday> allHolidays = Generics.newHashSet();
        JollyDayHolidays.getAllHolidays(config, allHolidays);
        return allHolidays;
    }

    private static boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType());
    }

    public static class JollyHoliday
    extends SUTime.Time {
        private static final long serialVersionUID = -1479143694893729803L;
        private final HolidayManager holidayManager;
        private final Holiday base;
        private final String label;

        public JollyHoliday(String label, HolidayManager holidayManager, Holiday base) {
            this.label = label;
            this.holidayManager = holidayManager;
            this.base = base;
        }

        @Override
        public String toFormattedString(int flags) {
            if (this.getTimeLabel() != null) {
                return this.getTimeLabel();
            }
            if ((flags & 1) != 0) {
                return null;
            }
            return this.label;
        }

        @Override
        public boolean isGrounded() {
            return false;
        }

        @Override
        public SUTime.Time getTime() {
            return this;
        }

        @Override
        public SUTime.Duration getDuration() {
            return SUTime.DURATION_NONE;
        }

        @Override
        public SUTime.Range getRange(int flags, SUTime.Duration granularity) {
            return new SUTime.Range((SUTime.Time)this, this);
        }

        @Override
        public String toISOString() {
            return this.base.toString();
        }

        @Override
        public SUTime.Time intersect(SUTime.Time t) {
            SUTime.Time resolved = this.resolve(t, 0);
            if (resolved != this) {
                return resolved.intersect(t);
            }
            return super.intersect(t);
        }

        @Override
        public SUTime.Time resolve(SUTime.Time t, int flags) {
            Partial p;
            Partial partial = p = t != null ? t.getJodaTimePartial() : null;
            if (p != null && JodaTimeUtils.hasField((ReadablePartial)p, DateTimeFieldType.year())) {
                int year = p.get(DateTimeFieldType.year());
                Set holidays = this.holidayManager.getHolidays(year, new String[0]);
                for (de.jollyday.Holiday h : holidays) {
                    if (!h.getPropertiesKey().equals(this.base.getDescriptionPropertiesKey())) continue;
                    return new SUTime.PartialTime(this, new Partial((ReadablePartial)h.getDate()));
                }
            }
            return this;
        }

        @Override
        public SUTime.Time add(SUTime.Duration offset) {
            return new SUTime.RelativeTime(this, SUTime.TemporalOp.OFFSET_EXACT, offset);
        }
    }

    public static class MyXMLManager
    extends XMLManager {
        public Configuration getConfiguration() {
            return this.configuration;
        }
    }
}

