/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class GoogleNGramsSQLBacked {
    @Execution.Option(name="populateTables")
    static boolean populateTables = false;
    @Execution.Option(name="ngramsToPopulate")
    static Set<Integer> ngramsToPopulate = null;
    @Execution.Option(name="dataDir")
    static String dataDir = "/u/nlp/scr/data/google-ngrams/data";
    @Execution.Option(name="googleNgram_hostname", gloss="where psql is located.")
    static String googleNgram_hostname = "jonsson";
    @Execution.Option(name="googleNgram_dbname", gloss="the database name")
    static String googleNgram_dbname;
    @Execution.Option(name="googleNgram_username")
    static String googleNgram_username;
    @Execution.Option(name="tablenamePrefix")
    static String tablenamePrefix;
    @Execution.Option(name="escapetag")
    static String escapetag;
    static Set<String> existingTablenames;
    static Connection connection;
    private static String DBName;

    static void connect() throws SQLException {
        if (connection == null) {
            assert (googleNgram_dbname != null) : "set googleNgram_dbname variable through the properties file";
            connection = DriverManager.getConnection("jdbc:postgresql://" + googleNgram_hostname + "/" + googleNgram_dbname, googleNgram_username, "");
        }
    }

    static String escapeString(String str) {
        return "$" + escapetag + "$" + str + "$" + escapetag + "$";
    }

    public static boolean existsTable(String tablename) throws SQLException {
        if (existingTablenames == null) {
            existingTablenames = new HashSet<String>();
            DatabaseMetaData md = connection.getMetaData();
            ResultSet rs = md.getTables(null, null, "%", null);
            while (rs.next()) {
                existingTablenames.add(rs.getString(3).toLowerCase());
            }
        }
        return existingTablenames.contains(tablename.toLowerCase());
    }

    public static long getCount(String str) {
        String query = null;
        try {
            GoogleNGramsSQLBacked.connect();
            str = str.trim();
            if (str.contains("'")) {
                str = StringUtils.escapeString(str, new char[]{'\''}, '\'');
            }
            int ngram = str.split("\\s+").length;
            String table = tablenamePrefix + ngram;
            if (!GoogleNGramsSQLBacked.existsTable(table)) {
                return -1L;
            }
            String phrase = GoogleNGramsSQLBacked.escapeString(str);
            query = "select count from " + table + " where phrase='" + phrase + "';";
            Statement stmt = connection.createStatement();
            ResultSet result = stmt.executeQuery(query);
            if (result.next()) {
                return result.getLong("count");
            }
            return -1L;
        }
        catch (SQLException e) {
            System.err.println("Error getting count for " + str + ". The query was " + query);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static List<Pair<String, Long>> getCounts(Collection<String> strs) throws SQLException {
        GoogleNGramsSQLBacked.connect();
        ArrayList<Pair<String, Long>> counts = new ArrayList<Pair<String, Long>>();
        String query = "";
        for (String str : strs) {
            str = str.trim();
            int ngram = str.split("\\s+").length;
            String table = tablenamePrefix + ngram;
            if (!GoogleNGramsSQLBacked.existsTable(table)) {
                counts.add(new Pair<String, Long>(str, -1L));
                continue;
            }
            String phrase = GoogleNGramsSQLBacked.escapeString(str);
            query = query + "select count from " + table + " where phrase='" + phrase + "';";
        }
        if (query.isEmpty()) {
            return counts;
        }
        PreparedStatement stmt = connection.prepareStatement(query);
        boolean isresult = stmt.execute();
        Iterator<String> iter = strs.iterator();
        do {
            ResultSet rs = stmt.getResultSet();
            String ph = iter.next();
            if (rs.next()) {
                counts.add(new Pair<String, Long>(ph, rs.getLong("count")));
                continue;
            }
            counts.add(new Pair<String, Long>(ph, -1L));
        } while (isresult = stmt.getMoreResults());
        assert (counts.size() == strs.size());
        return counts;
    }

    public static void populateTablesInSQL(String dir, Collection<Integer> typesOfPhrases) throws SQLException {
        GoogleNGramsSQLBacked.connect();
        Statement stmt = connection.createStatement();
        for (Integer n : typesOfPhrases) {
            String table = tablenamePrefix + n;
            if (!GoogleNGramsSQLBacked.existsTable(table)) {
                throw new RuntimeException("Table " + table + " does not exist in the database! Run the following commands in the psql prompt:" + "create table GoogleNgrams_<NGRAM> (phrase text primary key not null, count bigint not null); create index phrase_<NGRAM> on GoogleNgrams_<NGRAM>(phrase);");
            }
            for (String line : IOUtils.readLines(new File(dir + "/" + n + "gms/vocab_cs.gz"), GZIPInputStream.class)) {
                String[] tok = line.split("\t");
                String q = "INSERT INTO " + table + " (phrase, count) VALUES (" + GoogleNGramsSQLBacked.escapeString(tok[0]) + " , " + tok[1] + ");";
                stmt.execute(q);
            }
        }
    }

    public static int getTotalCount(int ngram) {
        try {
            GoogleNGramsSQLBacked.connect();
            Statement stmt = connection.createStatement();
            String table = tablenamePrefix + ngram;
            String q = "select count(*) from " + table + ";";
            ResultSet s = stmt.executeQuery(q);
            if (s.next()) {
                return s.getInt(1);
            }
            throw new RuntimeException("getting table count is not working!");
        }
        catch (SQLException e) {
            throw new RuntimeException("getting table count is not working! " + e);
        }
    }

    public static int get1GramRank(String str) {
        String query = null;
        try {
            int ngram;
            GoogleNGramsSQLBacked.connect();
            str = str.trim();
            if (str.contains("'")) {
                str = StringUtils.escapeString(str, new char[]{'\''}, '\'');
            }
            if ((ngram = str.split("\\s+").length) > 1) {
                return -1;
            }
            String table = "googlengrams_1_ranked20k";
            if (!GoogleNGramsSQLBacked.existsTable(table)) {
                return -1;
            }
            String phrase = GoogleNGramsSQLBacked.escapeString(str);
            query = "select rank from " + table + " where phrase='" + phrase + "';";
            Statement stmt = connection.createStatement();
            ResultSet result = stmt.executeQuery(query);
            if (result.next()) {
                return result.getInt("rank");
            }
            return -1;
        }
        catch (SQLException e) {
            System.err.println("Error getting count for " + str + ". The query was " + query);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
        connection = null;
    }

    public static void main(String[] args) {
        try {
            String p;
            Properties props = StringUtils.argsToPropertiesWithResolve(args);
            Execution.fillOptions(GoogleNGramsSQLBacked.class, props);
            GoogleNGramsSQLBacked.connect();
            System.out.println("For head,the count is " + GoogleNGramsSQLBacked.getCount("head"));
            System.out.println(GoogleNGramsSQLBacked.getCounts(Arrays.asList("cancer", "disease")));
            System.out.println("Get count 1 gram " + GoogleNGramsSQLBacked.getTotalCount(1));
            if (props.getProperty("phrase") != null) {
                p = props.getProperty("phrase");
                System.out.println("count for phrase " + p + " is " + GoogleNGramsSQLBacked.getCount(p));
            }
            if (props.getProperty("rank") != null) {
                p = props.getProperty("rank");
                System.out.println("Rank of " + p + " is " + GoogleNGramsSQLBacked.get1GramRank(p));
            }
            GoogleNGramsSQLBacked.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDBName(String DBName) {
        googleNgram_dbname = DBName;
    }

    static {
        googleNgram_username = "nlp";
        tablenamePrefix = "googlengrams_";
        escapetag = "tag";
        existingTablenames = null;
        connection = null;
    }
}

